/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.content.capability;

import com.xiaoyue.tinkers_ingenuity.TinkersIngenuity;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.TIToolStats;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class EnergyCapability
implements ToolCapabilityProvider.IToolCapabilityProvider,
IEnergyStorage {
    public static final String STORED_ENERGY_KEY = "tooltip.tinkers_ingenuity.modifier.stored_energy";
    public static final ResourceLocation MAX_ENERGY = TinkersIngenuity.location("max_energy");
    public static final ResourceLocation STORED_ENERGY = TinkersIngenuity.location("stored_energy");
    public static final ResourceLocation ENERGY_OWNER = TinkersIngenuity.location("energy_owner");
    private static final int MAX_TRANSFER_RATE = 1000;
    protected final Supplier<? extends IToolStackView> tool;
    private final LazyOptional<IEnergyStorage> capOptional;

    public EnergyCapability(ItemStack stack, Supplier<? extends IToolStackView> toolStack) {
        this.tool = toolStack;
        this.capOptional = LazyOptional.of(() -> this);
    }

    public static int receiveEnergy(IToolStackView tool, int maxReceive, boolean simulate) {
        int energyStored = EnergyCapability.getEnergyStored(tool);
        int energyReceived = Math.min(EnergyCapability.getMaxEnergyStored(tool) - energyStored, Math.min(1000, maxReceive));
        if (!simulate) {
            ModDataNBT persistentData = tool.getPersistentData();
            persistentData.putInt(STORED_ENERGY, energyStored + energyReceived);
        }
        return energyReceived;
    }

    public static boolean removeEnergy(IToolStackView tool, int energyRemoved, boolean simulate, boolean drain) {
        int energyStored = EnergyCapability.getEnergyStored(tool);
        if (energyStored < energyRemoved) {
            if (drain && !simulate) {
                ModDataNBT persistentData = tool.getPersistentData();
                persistentData.putInt(STORED_ENERGY, 0);
            }
            return false;
        }
        if (!simulate) {
            ModDataNBT persistentData = tool.getPersistentData();
            persistentData.putInt(STORED_ENERGY, energyStored - energyRemoved);
        }
        return true;
    }

    public static int getEnergyStored(IToolStackView tool) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(STORED_ENERGY, 3)) {
            return persistentData.getInt(STORED_ENERGY);
        }
        return 0;
    }

    public static int getMaxEnergyStored(IToolStackView tool) {
        IModDataView volatileData = tool.getVolatileData();
        if (volatileData.contains(MAX_ENERGY, 3)) {
            int energy_store = tool.getStats().getInt((IToolStat)TIToolStats.ENERGY_STORE);
            if (energy_store > 0) {
                return volatileData.getInt(MAX_ENERGY) + energy_store;
            }
            return volatileData.getInt(MAX_ENERGY);
        }
        return 0;
    }

    public <T> LazyOptional<T> getCapability(IToolStackView tool, Capability<T> cap) {
        if (tool.getVolatileData().getInt(MAX_ENERGY) > 0 && cap == ForgeCapabilities.ENERGY) {
            return ForgeCapabilities.ENERGY.orEmpty(cap, this.capOptional);
        }
        return LazyOptional.empty();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return EnergyCapability.receiveEnergy(this.tool.get(), maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return EnergyCapability.getEnergyStored(this.tool.get());
    }

    public int getMaxEnergyStored() {
        return EnergyCapability.getMaxEnergyStored(this.tool.get());
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

